

<?php $__env->startSection('content'); ?>

<div class="sm:mx-auto sm:w-full sm:max-w-md">
    <?php if(file_exists(public_path('logo.png'))): ?>
    <div class="text-center">
        <img src="<?php echo e(asset('logo.png')); ?>" alt="<?php echo e(config('app.name')); ?>" style="width: 50%;height: auto;border-radius: 10px;" class="mx-auto h-12 w-auto">
    </div>
    <?php endif; ?>
</div>

<?php if(!$isUpdateAvailable): ?>
<div class="panel">
    <h3 class="text-success-500">Great news! No update available at this time. Your system is up-to-date and running smoothly.</h3>

    <div class="-m-7 mt-6 rounded-b border-t border-neutral-200 bg-neutral-50 p-4 text-center">
        <a href="<?php echo e(url('login')); ?>" rel="noopener noreferrer" class="inline-flex items-center rounded-md border border-transparent bg-primary-600 px-4 py-2 text-sm text-white shadow-sm focus:outline-none focus:ring-2 focus:ring-primary-500 focus:ring-offset-2 hover:bg-primary-700">
            Login to Continue
        </a>
    </div>
</div>
<?php endif; ?>

<?php if($isRequirementsErrors): ?>
<div class="panel">
    <h3>Detected the following problems. Please correct them before proceeding with the update.</h3>
    <ul class="errors">
        <?php $__currentLoopData = $requirements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $req): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php if(!$req['result']): ?>
        <li><?php echo e($req['errorMessage']); ?></li>
        <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </ul>
</div>
<?php endif; ?>

<?php if($isUpdateAvailable): ?>
<form class="panel" action="update/run" method="post">
    <?php echo e(csrf_field()); ?>

    <p class="text-success-500">Exciting news! A new update is available for your system. Stay ahead with the latest features, improvements, and enhancements by updating now.</p>
    <p>This might take several minutes, please don't close this browser tab while update is in progress.</p>
    <?php if($isRequirementsErrors): ?>
    <button class="button bg-primary-600" type="submit" disabled>Update Now</button>
    <?php else: ?>
    <button class="button bg-primary-600" type="submit">Update Now</button>
    <?php endif; ?>
</form>
<?php endif; ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('update.update-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Projects\DocMgtPHP\docmgtphpapi\resources\views/update/update.blade.php ENDPATH**/ ?>