<div class="p-3">
    <h4 class="text-lg my-5 text-neutral-800 font-semibold">Files and folders permissions</h4>
    <p class="text-neutral-700">
        These folders must be writable by web server user: <strong
            class="select-all"><?php echo e(get_current_user()); ?></strong>
        <br />Recommended permissions: <strong class="select-all">0775</strong><br /><br />
    </p>

    <div class="flex flex-col">
        <div class="-my-2 overflow-x-auto sm:-mx-6 lg:-mx-8">
            <div class="py-2 align-middle inline-block min-w-full sm:px-6 lg:px-8">
                <div class="shadow overflow-hidden border-b border-neutral-200 sm:rounded-lg">
                    <table class="min-w-full divide-y divide-neutral-200">
                        <thead class="bg-neutral-50">
                            <tr>
                                <th scope="col"
                                    class="px-4 py-3 text-left text-xs font-medium text-neutral-500 uppercase tracking-wider">
                                    Path
                                </th>
                                <th scope="col"
                                    class="px-4 py-3 text-left text-xs font-medium text-neutral-500 uppercase tracking-wider">
                                    Permission
                                </th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-neutral-200">
                            <?php $__currentLoopData = $permissions['results']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td class="px-4 py-2 whitespace-nowrap text-sm font-medium text-neutral-900">
                                        <?php echo e(rtrim($permission['folder'], '/')); ?>

                                    </td>
                                    <td class="px-4 py-2 whitespace-nowrap text-sm font-medium text-neutral-900">
                                        <span
                                            class="inline-flex <?php echo e($permission['isSet'] ? 'text-success-500' : 'text-warning-500'); ?>">
                                            <?php if($permission['isSet']): ?>
                                                <?php echo $__env->make('installer.passes-icon', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                            <?php endif; ?>
                                            <?php echo e($permission['permission']); ?>

                                        </span>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH D:\Projects\DocMgtPHP\docmgtphpapi\resources\views/installer/includes/permissions.blade.php ENDPATH**/ ?>